<?php $__env->startSection('title','Riwayat Gaji'); ?>

<?php $__env->startSection('content'); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="fw-bold mb-1">Riwayat Gaji</h4>
        <small class="text-muted">Rekap dan perhitungan gaji karyawan</small>
    </div>



    <a href="<?php echo e(route('admin.gaji.create')); ?>" class="btn btn-primary btn-sm d-flex align-items-center">
        <i class="fas fa-plus me-2"></i> Hitung Gaji
    </a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card shadow-sm border-0">
    <div class="card-body">

        <table class="table table-hover align-middle">
    <thead class="table-light">
        <tr>
            <th>#</th>
            <th>Karyawan</th>
            <th>Bulan</th>
            <th>Tahun</th>
            <th>Hadir</th>
            <th>Gaji Harian</th>
            <th>Total Gaji</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $gaji; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
            <td><?php echo e($loop->iteration); ?></td>
            <td><?php echo e($g->karyawan->user->nama); ?></td>
            <td>
                <?php echo e(\Carbon\Carbon::create()->month($g->bulan)->locale('id')->monthName); ?>

            </td>
            <td><?php echo e($g->tahun); ?></td>
            <td>
                <span class="badge bg-success">
                    <?php echo e($g->total_hadir); ?> Hari
                </span>
            </td>
            <td>
                Rp <?php echo e(number_format($g->gaji_harian, 0, ',', '.')); ?>

            </td>
            <td class="fw-semibold text-primary">
                Rp <?php echo e(number_format($g->total_gaji, 0, ',', '.')); ?>

            </td>
            <td>
    <a href="<?php echo e(route('admin.gaji.slip', $g->id)); ?>"
       class="btn btn-sm btn-outline-primary">
        <i class="fas fa-file-pdf"></i> Slip
    </a>
</td>

        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr>
            <td colspan="7" class="text-center text-muted py-4">
                Belum ada data gaji
            </td>
        </tr>
        <?php endif; ?>
    </tbody>
</table>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\DAVA\Documents\FILE_SEKOLAH\WEB XII\absensi-hotel - Copy\resources\views/admin/gaji/index.blade.php ENDPATH**/ ?>